/*  Die Beginn- und Endzeit der Arbeitsgänge in die ABK syncronisieren.
*/
SELECT tsystem.function__drop_by_regex( 'abk__at_et__from__ab2__sync', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.abk__at_et__from__ab2__sync( _ab_ix int ) RETURNS void AS $$
  DECLARE
    _ab_at date;
    _ab_et date;

    _start_time time;

  BEGIN

      _start_time := clock_timestamp()::time;

      SELECT  min( a2_at )::date, max( a2_et )::date
        INTO    _ab_at            , _ab_et
        FROM ab2
       WHERE a2_ab_ix = _ab_ix
         AND NOT a2_ende
         AND a2_interm
         ; -- wenn beendete AGs später liegen als nach vorn gezogene frühere

      UPDATE abk
         SET ab_at = _ab_at,
             ab_et = _ab_et
       WHERE ab_ix = _ab_ix
         AND ( ab_at IS DISTINCT FROM _ab_at OR ab_et IS DISTINCT FROM _ab_et );

       -- => abk__a_iud => auftgi und ldsdok
      RAISE NOTICE 'abk__at_et__from__ab2__sync ABK:%, AT:%, ET:%, Duration:%, Start:%, Leave:%', _ab_ix, _ab_at, _ab_et, clock_timestamp()::time - _start_time, _start_time, clock_timestamp()::time;

  END $$ LANGUAGE plpgsql;
